/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapping.tile.floor;

import technology.rocketjump.undermount.assets.model.FloorType;
import technology.rocketjump.undermount.assets.model.GameMaterial;
import technology.rocketjump.undermount.mapping.tile.MapVertex;
import technology.rocketjump.undermount.mapping.tile.floor.OverlapLayout;

public class FloorOverlap {
    private final OverlapLayout layout;
    private final FloorType floorType;
    private final GameMaterial material;
    private float[] vertexColors = new float[4];

    public FloorOverlap(OverlapLayout layout, FloorType floorType, GameMaterial material, MapVertex[] vertexNeighboursOfCell) {
        this.layout = layout;
        this.floorType = floorType;
        this.material = material;
        if (floorType.isUseMaterialColor()) {
            float floorMaterialColor;
            this.vertexColors[0] = floorMaterialColor = material.getColor().toFloatBits();
            this.vertexColors[1] = floorMaterialColor;
            this.vertexColors[2] = floorMaterialColor;
            this.vertexColors[3] = floorMaterialColor;
        } else {
            this.vertexColors[0] = floorType.getColorForHeightValue(vertexNeighboursOfCell[0].getHeightmapValue()).toFloatBits();
            this.vertexColors[1] = floorType.getColorForHeightValue(vertexNeighboursOfCell[1].getHeightmapValue()).toFloatBits();
            this.vertexColors[2] = floorType.getColorForHeightValue(vertexNeighboursOfCell[2].getHeightmapValue()).toFloatBits();
            this.vertexColors[3] = floorType.getColorForHeightValue(vertexNeighboursOfCell[3].getHeightmapValue()).toFloatBits();
        }
    }

    public OverlapLayout getLayout() {
        return this.layout;
    }

    public GameMaterial getMaterial() {
        return this.material;
    }

    public FloorType getFloorType() {
        return this.floorType;
    }

    public float[] getVertexColors() {
        return this.vertexColors;
    }
}

